(function() {
  //    FILE:EventCollection
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['Backbone', 'Backbone.LocalStorage', 'moment', 'models/timereport/TimereportModel', 'models/request/RequestModel'], function(Backbone, LocalStorage, Moment, TimereportModel, RequestModel) {
    var TimereportCollection;
    return TimereportCollection = (function() {
      class TimereportCollection extends Backbone.Collection {
        initialize() {
          return this.reqMdl = new RequestModel();
        }

        get_recent_timereports(usr) {
          var jsonReq, response, that, xmlReq;
          that = this;
          jsonReq = this.reqMdl.get('JGetRecentTimereports');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var jsonObj, trs;
            jsonObj = data;
            trs = jsonObj.Result.Timereport;
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              //# DELETING ALL MODELS
              that.reset();
              if (_.isArray(trs)) {
                _.each(trs, function(tr) {
                  return that.add(tr);
                });
              } else if (trs) {
                that.add(trs);
              }
              that.trigger('change');
              return that.trigger('timereportRCchanged');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {});
          return this;
        }

        get_not_done_timereports(usr) {
          var jsonReq, response, that, xmlReq;
          that = this;
          this.__clean_localStorage();
          jsonReq = this.reqMdl.get('JGetNotDoneTimereports');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var jsonObj, now, trs;
            jsonObj = data;
            trs = jsonObj.Result.Timereport;
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              //# DELETING ALL MODELS
              that.reset();
              if (_.isArray(trs)) {
                _.each(trs, function(tr) {
                  return that.create(tr, {
                    silent: true
                  });
                });
              } else if (trs) {
                that.create(trs, {
                  silent: true
                });
              }
              that.trigger('change');
              that.trigger('timereportNDchanged');
              now = Moment();
              return usr.save({
                'timereport_updated_at': now.format('YYYY-MM-DD hh:mm:ss')
              });
            } else {

            }
          //console.log jsonObj.Result
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {});
          return this;
        }

        get_number_not_done_timereports() {
          //_.uniq(_.pluck(this.toJSON(),'bookingID')).length
          return this.models.length;
        }

        find_timereport_by_id(id) {
          return this.get(id);
        }

        __clean_localStorage() {
          var ref;
          return _.each((ref = window.localStorage.getItem('Timereports')) != null ? ref.split(',') : void 0, function(id) {
            var tID;
            tID = "Timereports-" + id;
            return window.localStorage.removeItem(tID);
          });
        }

      };

      TimereportCollection.prototype.model = TimereportModel;

      TimereportCollection.prototype.localStorage = new LocalStorage('Timereports');

      return TimereportCollection;

    }).call(this);
  });

  //          N = @.length
//          for i in [N-1..0] by -1
//            #console.log 'Cleaning '+i
//            @.at(i).destroy({silent:true})

}).call(this);
